#include "FS803A.h"
#include "af901x.h"
#include "FS_mcf5307.h"
#include "FS_i2c.h"
#include "FS_tuner.h"
#include "FS_tuner_globals.h"

#define AF901X_CAN_TUNER            0x1
#define AF901X_SILICON_TUNER        0x2

extern  U8Data   demodAddress_;
extern  U8Data   tunerAddress_;
extern  U8Data   slaveDemod_;
extern  void *  handle_;

int i2c_xmit (uint8 address, int length, unsigned char *data)
{
	UData_t error = 0;
	U8Data buffer[64];
	int i;
	
#if BIG_ENDIAN
	for (i = 0; i < length; i++)
		buffer[i] = *(data + i);
#else
	for (i = 0; i < length; i++)
		buffer[i] = *(data - i);
#endif

	error = Af901xWriteTunerRegs (demodAddress_, slaveDemod_, tunerAddress_, AF901X_CAN_TUNER, 0, length, buffer);	

	return (error);
}


int i2c_rcv (uint8 address, int length, unsigned char *data)
{
	UData_t error = 0;
	U8Data buffer[64];
	int i;

	error = Af901xReadTunerRegs (demodAddress_, slaveDemod_, tunerAddress_, AF901X_CAN_TUNER, 0, length, buffer);

#if BIG_ENDIAN
	for (i = 0; i < length; i++)
		*(data + i) = buffer[i];
#else
	for (i = 0; i < length; i++)
		*(data - i) = buffer[i];
#endif
	return (error);
}

